package goodtime.rest.client;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

/**
 *
 * Created on 20.08.2023
 */
public class RestLoginClient {

    private String token;
    private String id;

    public static void main(String[] aArguments) {
        RestLoginClient rSLoginClient = new RestLoginClient();
        rSLoginClient.hello();
        rSLoginClient.login();
        rSLoginClient.securedHello();
    }

    public void hello() {
            Response response = null;
        try {
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/hello")
                    .path("sayhello").request().get();
            System.out.println(response.readEntity(String.class));
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void securedHello() {
        Response response = null;
        try {
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/hello")
                    .path("securedSayhello").request().header(HttpHeaders.AUTHORIZATION, token).get();
            System.out.println(response);
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void login() {
        Response response = null;
        try {
            // Credentials credentials = new Credentials("admin@someaccount.de", "123456");
            String credentialsString = "{ \"loginemail\": \"admin@someaccount.de\", \"apipassword\": \"12345678\" }";
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/login")
                    .request(MediaType.APPLICATION_JSON)
                    .post(Entity.entity(credentialsString, MediaType.APPLICATION_JSON));

            id = response.readEntity(String.class);
            System.out.println("id: " + id);
            token = response.getHeaderString(HttpHeaders.AUTHORIZATION);
            System.out.println("token: " + token);
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }
}
