/*
 * Decompiled with CFR 0.152.
 */
package goodtime.rest.client;

import goodtime.rest.model.Timeentry;
import goodtime.rest.model.Timetype;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.List;

public class RestTimeClient {
    private String token;
    private String companyId;
    private static String createdTimeentryId;

    public static void main(String[] aArguments) {
        RestTimeClient rSTimeClient = new RestTimeClient();
        rSTimeClient.login();
        rSTimeClient.getTimetypes();
        rSTimeClient.getUsers();
        rSTimeClient.getProjects();
        rSTimeClient.getProjectsForUser();
        createdTimeentryId = rSTimeClient.createTimeentry();
        rSTimeClient.getTimeientriesForUser();
        rSTimeClient.deleteTimeentry(createdTimeentryId);
    }

    public void login() {
        try (Response response = null;){
            String credentialsString = "{ \"loginemail\": \"admin@someaccount.de\", \"apipassword\": \"12345678\" }";
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/login").request(new String[]{"application/json"}).post(Entity.entity((Object)credentialsString, (String)"application/json"));
            this.companyId = (String)response.readEntity(String.class);
            System.out.println("id: " + this.companyId);
            this.token = response.getHeaderString("Authorization");
            System.out.println("token: " + this.token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTimetypes() {
        try (Response response = null;){
            response = (Response)ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1").path("timetypes").request().accept(new String[]{"application/json"}).header("Authorization", (Object)this.token).get(Response.class);
            System.out.println(response);
            GenericType<List<Timetype>> genericType = new GenericType<List<Timetype>>(){};
            List timetypes = (List)response.readEntity((GenericType)genericType);
            System.out.println("Timetypes:");
            for (Timetype timetype : timetypes) {
                System.out.println("Id: " + timetype.getId() + ", name: " + timetype.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getUsers() {
        try (Response response = null;){
            response = (Response)ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1").path("users").request().accept(new String[]{"application/json"}).header("Authorization", (Object)this.token).get(Response.class);
            System.out.println(response);
            GenericType<List<String>> genericType = new GenericType<List<String>>(){};
            List loginEmailList = (List)response.readEntity((GenericType)genericType);
            System.out.println("Strings:");
            for (String loginemail : loginEmailList) {
                System.out.println("Loginemail: " + loginemail);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProjects() {
        try (Response response = null;){
            response = (Response)ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1").path("projects").request().accept(new String[]{"application/json"}).header("Authorization", (Object)this.token).get(Response.class);
            System.out.println(response);
            System.out.println("Projects:");
            GenericType<List<Timetype>> genericType = new GenericType<List<Timetype>>(){};
            List timetypes = (List)response.readEntity((GenericType)genericType);
            for (Timetype timetype : timetypes) {
                System.out.println("Id: " + timetype.getId() + ", name: " + timetype.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProjectsForUser() {
        try (Response response = null;){
            response = (Response)ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1").path("projects").path("max@muster.com").request().accept(new String[]{"application/json"}).header("Authorization", (Object)this.token).get(Response.class);
            System.out.println(response);
            System.out.println("Projects for user:");
            GenericType<List<Timetype>> genericType = new GenericType<List<Timetype>>(){};
            List timetypes = (List)response.readEntity((GenericType)genericType);
            for (Timetype timetype : timetypes) {
                System.out.println("Id: " + timetype.getId() + ", name: " + timetype.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTimeientriesForUser() {
        try (Response response = null;){
            response = (Response)ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1").path("timeentries").queryParam("useremail", new Object[]{"max@muster.com"}).queryParam("start", new Object[]{"2020-01-01T00:00:00"}).queryParam("end", new Object[]{"2020-01-07T23:59:00"}).request().accept(new String[]{"text/plain"}).header("Authorization", (Object)this.token).get(Response.class);
            System.out.println(response);
            GenericType<List<Timeentry>> genericType = new GenericType<List<Timeentry>>(){};
            List timeentries = (List)response.readEntity((GenericType)genericType);
            System.out.println(timeentries.size() + " timeentries for user:");
            System.out.println("timeentries for user: " + timeentries);
            for (Timeentry timeentry : timeentries) {
                System.out.println(timeentry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTimeentry() {
        try (Response response = null;){
            Timeentry timeentry = new Timeentry();
            timeentry.setUseremail("admin@someaccount.de");
            timeentry.setStarttime("2022-05-19T10:33:00");
            timeentry.setEndtime("2022-05-19T10:44:00");
            timeentry.setTimetypeid("4e63f61d-dafd-4775-b88d-31fda699cba1");
            timeentry.setProjectid("0137a6bf-ccdf-442f-a937-5642197276ea");
            timeentry.setComment("my comment");
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1").path("createtimeentry").request().accept(new String[]{"application/json"}).header("Authorization", (Object)this.token).post(Entity.entity((Object)timeentry, (String)"application/json"));
            System.out.println(response);
            if (response.getStatus() == 200) {
                GenericType<List<String>> genericType = new GenericType<List<String>>(){};
                List idList = (List)response.readEntity((GenericType)genericType);
                for (String id : idList) {
                    System.out.println("cretated id: " + id);
                }
                String string = (String)idList.get(0);
                return string;
            }
        }
        return null;
    }

    public void deleteTimeentry(String timeentryId) {
        try (Response response = null;){
            response = (Response)ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1").path("deletetimeentry").path(timeentryId).request().accept(new String[]{"text/plain"}).header("Authorization", (Object)this.token).delete(Response.class);
            System.out.println(response);
        }
    }
}

